/*
 * Decompiled with CFR 0.152.
 */
package com.servoy.bootstrapper;

import com.servoy.bootstrapper.BaseBootstrap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class SalesManagerCRM
extends BaseBootstrap {
    public static final String CODEBASE_PROPERTY = "codebase";
    public static final String SOLUTION_PROPERTY = "solution";

    public static void main(String[] args) throws MalformedURLException, FileNotFoundException, IOException {
        ArrayList<String> arguments;
        int threadPoolSize;
        String solution;
        URL codebase;
        InputStream is = BaseBootstrap.class.getResourceAsStream("/bootstrap.properties");
        if (is != null) {
            String value;
            Properties properties = new Properties();
            properties.load(is);
            String codebaseString = properties.getProperty(CODEBASE_PROPERTY);
            if (codebaseString == null) {
                throw new RuntimeException("Code base not set in the boostrap properties file");
            }
            codebase = new URL(codebaseString);
            solution = properties.getProperty(SOLUTION_PROPERTY, "servoy_client");
            threadPoolSize = Integer.parseInt(properties.getProperty("bootstrapthreadpoolsize", "8"));
            String homeDir = properties.getProperty(" jnlp.bootstrapper.home.dir");
            if (homeDir != null) {
                System.setProperty(" jnlp.bootstrapper.home.dir", homeDir);
            }
            System.setProperty("com.servoy.remote.codebase", codebaseString);
            System.setProperty("com.servoy.remote.checker", "com.servoy.j2db.smart.StandAloneRemoteChecker");
            arguments = new ArrayList<String>();
            int i = 0;
            while ((value = properties.getProperty("arg" + i)) != null) {
                arguments.add(value);
                ++i;
            }
        } else {
            throw new RuntimeException("bootstrap.properties not found");
        }
        SalesManagerCRM.loadAndStartClient(solution, codebase, threadPoolSize, arguments.toArray(new String[arguments.size()]));
    }
}

