/*
 * Decompiled with CFR 0.152.
 */
package com.servoy.bootstrapper;

import com.servoy.bootstrapper.BaseBootstrap;
import com.servoy.bootstrapper.JarDownloader;
import com.servoy.bootstrapper.NativeLibDownloader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JProgressBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JNLPParser
implements Runnable {
    private final URL url;
    private final ThreadPoolExecutor threadPool;
    private final URL codeBase;
    private final File solutionCacheDir;
    private final JProgressBar bar;

    public JNLPParser(URL url, ThreadPoolExecutor threadPool, URL codeBase, File solutionCacheDir, JProgressBar bar) {
        this.url = url;
        this.threadPool = threadPool;
        this.codeBase = codeBase;
        this.solutionCacheDir = solutionCacheDir;
        this.bar = bar;
        BaseBootstrap.increaseMaximum(bar);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        InputStreamReader isr = null;
        Node jnlpDoc = null;
        int downloadCounter = 0;
        try {
            try {
                while (true) {
                    if (downloadCounter >= 5) {
                        NodeList childNodes = jnlpDoc.getChildNodes();
                        this.parseJNLP(childNodes);
                        return;
                    }
                    try {
                        try {
                            InputStream inputStream = this.url.openConnection().getInputStream();
                            isr = new InputStreamReader(inputStream);
                            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                            jnlpDoc = docBuilder.parse(new InputSource(isr));
                            try {
                                isr.close();
                                isr = null;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            downloadCounter = 5;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (++downloadCounter < 5) {
                                try {
                                    System.err.println("trying to download again: " + this.url);
                                    Thread.sleep(2000 * downloadCounter);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                            } else {
                                System.err.println("After 5 download tries this url failed to download, contact server adminstrator: " + this.url);
                            }
                            if (isr == null) continue;
                            try {
                                isr.close();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (isr == null) throw throwable;
                        try {
                            isr.close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    if (isr == null) continue;
                    try {
                        isr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                BaseBootstrap.increaseProgress(this.bar);
                return;
            }
        }
        finally {
            BaseBootstrap.increaseProgress(this.bar);
        }
    }

    private void parseJNLP(NodeList childNodes) throws MalformedURLException {
        int i = 0;
        while (i < childNodes.getLength()) {
            Node href;
            Node node = childNodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null && (href = attributes.getNamedItem("href")) != null) {
                if (node.getNodeName().equalsIgnoreCase("jar") || node.getNodeName().equalsIgnoreCase("zip")) {
                    this.threadPool.execute(new JarDownloader(new URL(this.codeBase, href.getNodeValue()), this.solutionCacheDir, this.bar));
                } else if (node.getNodeName().equalsIgnoreCase("extension")) {
                    this.threadPool.execute(new JNLPParser(new URL(this.codeBase, href.getNodeValue()), this.threadPool, this.codeBase, this.solutionCacheDir, this.bar));
                } else if (node.getNodeName().equalsIgnoreCase("nativelib")) {
                    this.threadPool.execute(new NativeLibDownloader(new URL(this.codeBase, href.getNodeValue()), this.solutionCacheDir, this.bar));
                }
            }
            boolean parseChildNodes = true;
            if ("resources".equals(node.getNodeName()) && node.getAttributes() != null && (node.getAttributes().getNamedItem("os") != null || node.getAttributes().getNamedItem("arch") != null)) {
                String arch;
                String os = node.getAttributes().getNamedItem("os").getNodeValue();
                if (os != null) {
                    String currentOs = System.getProperty("os.name");
                    boolean bl = parseChildNodes = os.contains(currentOs) || currentOs.contains(os);
                }
                if (parseChildNodes && (arch = node.getAttributes().getNamedItem("arch").getNodeValue()) != null) {
                    String currentArch = System.getProperty("os.arch");
                    boolean bl = parseChildNodes = arch.contains(currentArch) || currentArch.contains(arch);
                }
            }
            if (parseChildNodes) {
                this.parseJNLP(node.getChildNodes());
            }
            ++i;
        }
    }
}

