/*
 * Decompiled with CFR 0.152.
 */
package com.servoy.bootstrapper;

import com.servoy.bootstrapper.BaseBootstrap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class Bootstrap
extends BaseBootstrap {
    public static void main(String[] args) throws UnavailableServiceException, IOException, URISyntaxException {
        String solutionName = args.length > 0 ? args[0] : "servoy_client";
        System.setSecurityManager(null);
        BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        URL codeBaseUrl = bs.getCodeBase();
        int threadPoolSize = Bootstrap.getThreadPoolSize(args);
        Bootstrap.loadAndStartClient(solutionName, codeBaseUrl, threadPoolSize, args);
    }

    private static int getThreadPoolSize(String[] args) {
        int i = 1;
        while (i < args.length) {
            if (args[i].startsWith("bootstrapthreadpoolsize")) {
                try {
                    int val = Integer.parseInt(args[i].substring("bootstrapthreadpoolsize".length() + 1));
                    if (val > 0) {
                        return val;
                    }
                    System.out.println("Thread pool size must be a positive number, using default value: 8.");
                }
                catch (NumberFormatException e) {
                    System.out.println("Thread pool size argument is not a number, using default value: 8.");
                }
            }
            ++i;
        }
        return 8;
    }
}

